clear
close all
clc

% IMPORTANT: the drain currents ID are referred to a batch of 16 devices!
% For correct normalization divide ID by 16
% Measurements file names:
% 'GTS/C2IVG.crv'   = 20 nm
% 'GTS/C11IVG.crv'  = 27 nm
% 'GTS/C4IVG.crv'   = 34 nm

fileName = 'GTS/C4IVG.crv';
fid = fopen(fileName, 'r');
a = textscan(fid,'%s','delimiter','\n');
fclose(fid);
C = string(a{1});
A = zeros(56,9);
j = 4;

figure(1)
% set(gcf,'Position',[816 332 948 711])

for k = 1:2
    for i = 1:106
        B = sscanf(C(i+j), "%d %f %f %f %f %f %f %f %f");
        A(i,:) = B';
    end
    VD(:,k) = A(:,4);
    ID(:,k) = A(:,5);
    VG(:,k) = A(:,6);
    IG(:,k) = A(:,7);
    j = j + i + 1;

    grid on
    hold on
    box on
    xlabel('Gate-source voltage V_{GS}, V')
    ylabel('Drain current I_D, uA')
    xlim([-1.6, 0.5])
    xQuantity = 'GateOuterVoltage';
    yQuantity = 'DrainTotalCurrent';
    plot(VG(:,k),ID(:,k)*1e6/16,'--r','LineWidth',1.5)
    text(-1.55,-4.00,'VD = - 0.1 V')
    text(-1.55,-33.0,'VD = - 1.1 V')
end

figure(2)

for k = 1:2
    grid on
    hold on
    box on
    xlabel('Gate-source voltage V_{GS}, V')
    ylabel('Drain current I_D, A')
    xlim([-1.6, 0.5])
    ylim([-1e-4,-1e-16])
    set(gca,'YScale','log')
    set(gca,'YDir','reverse')
    xQuantity = 'GateOuterVoltage';
    yQuantity = 'DrainTotalCurrent';
    plot(VG(:,k),ID(:,k)/16,'--r','LineWidth',1.5)
    text(0.10,-3e-11,'VD = - 0.1 V')
    text(0.10,-3e-06,'VD = - 1.1 V')
end
